<?php
// Load WordPress
require_once('/var/www/html/wp-load.php');

// Get order #35
$order = wc_get_order(35);

if (!$order) {
    die("Order #35 not found\n");
}

echo "Order #35 found. Status: " . $order->get_status() . "\n";
echo "Customer: " . $order->get_billing_email() . "\n";

// Get items
foreach ($order->get_items() as $item_id => $item) {
    echo "\nItem: " . $item->get_name() . "\n";

    // Get meta data
    $fz_designs = $item->get_meta('_fz_designs');
    if ($fz_designs) {
        echo "  Designs: " . $fz_designs . "\n";
    }

    $fz_design_id = $item->get_meta('_fz_design_id');
    if ($fz_design_id) {
        echo "  Design ID: " . $fz_design_id . "\n";
    }
}

// Debug what data would be sent
$store_id = get_option('fz_store_id');
$auth_token = get_option('fz_auth_token');
echo "Store ID: " . $store_id . "\n";
echo "Auth Token: " . substr($auth_token, 0, 10) . "...\n";

// Check designs array structure
$designs = array();
foreach ($order->get_items() as $item_id => $item) {
    $product_id = $item->get_product_id();

    // Check for multiple designs
    $fz_designs = $item->get_meta('_fz_designs');
    if ($fz_designs) {
        echo "Raw designs meta: " . $fz_designs . "\n";
        $designs_data = json_decode($fz_designs, true);
        if (is_array($designs_data)) {
            foreach ($designs_data as $design) {
                echo "Design data: " . json_encode($design) . "\n";
                $designs[] = array(
                    'product_id' => $product_id,
                    'design_id' => $design,
                    'quantity' => $item->get_quantity()
                );
            }
        }
    }
}

echo "Designs to send: " . json_encode($designs) . "\n\n";

// Manually trigger the sync
echo "Triggering order sync...\n";
fz_send_order_to_dashboard($order);

echo "Done!\n";