<?php
// Load WordPress
require_once('/var/www/html/wp-load.php');

// Get all recent orders
$orders = wc_get_orders(array(
    'limit' => 20,
    'orderby' => 'date',
    'order' => 'DESC'
));

echo "Syncing all recent orders...\n";
echo str_repeat('-', 40) . "\n";

foreach ($orders as $order) {
    $order_id = $order->get_id();
    $has_designs = false;

    // Check if order has designs
    foreach ($order->get_items() as $item) {
        $fz_designs = $item->get_meta('_fz_designs');
        $fz_design_id = $item->get_meta('_fz_design_id');

        if ($fz_designs || $fz_design_id) {
            $has_designs = true;
            break;
        }
    }

    if ($has_designs) {
        echo "Order #$order_id: Syncing...\n";
        fz_send_order_to_dashboard($order);
        echo "  ✓ Sent to dashboard\n";
    } else {
        echo "Order #$order_id: No designs, skipping\n";
    }
}

echo str_repeat('-', 40) . "\n";
echo "Sync complete!\n";