<?php
// Load WordPress
require_once('/var/www/html/wp-load.php');

// Get latest orders
$orders = wc_get_orders(array(
    'limit' => 10,
    'orderby' => 'date',
    'order' => 'DESC'
));

echo "Latest WooCommerce Orders:\n";
echo str_repeat('-', 80) . "\n";

foreach ($orders as $order) {
    echo "Order #" . $order->get_id() . ":\n";
    echo "  Status: " . $order->get_status() . "\n";
    echo "  Customer: " . $order->get_billing_email() . "\n";
    echo "  Name: " . $order->get_billing_first_name() . " " . $order->get_billing_last_name() . "\n";
    echo "  Created: " . $order->get_date_created()->format('Y-m-d H:i:s') . "\n";
    echo "  Total: $" . $order->get_total() . "\n";

    // Check for FZ designs
    $has_designs = false;
    foreach ($order->get_items() as $item) {
        $fz_designs = $item->get_meta('_fz_designs');
        $fz_design_id = $item->get_meta('_fz_design_id');

        if ($fz_designs || $fz_design_id) {
            if (!$has_designs) {
                echo "  FZ Designs:\n";
                $has_designs = true;
            }

            if ($fz_designs) {
                $designs = json_decode($fz_designs, true);
                if (is_array($designs)) {
                    foreach ($designs as $design) {
                        echo "    - " . (is_string($design) ? $design : json_encode($design)) . "\n";
                    }
                }
            }

            if ($fz_design_id) {
                echo "    - Single: " . $fz_design_id . "\n";
            }
        }
    }

    if (!$has_designs) {
        echo "  FZ Designs: None\n";
    }

    echo str_repeat('-', 40) . "\n";
}

// Check if webhook is sending orders
$store_id = get_option('fz_store_id');
$auth_token = get_option('fz_auth_token');

echo "\nPlugin Configuration:\n";
echo "  Store ID: " . ($store_id ?: 'NOT SET') . "\n";
echo "  Auth Token: " . ($auth_token ? substr($auth_token, 0, 10) . '...' : 'NOT SET') . "\n";